// This program visualizes a given video and writes the average color per 
// frame as single pixels from the center of a circle outwards. In order 
// to visualize a video, put your movie (m4v, mp4, mov) into the "data" folder. 
// Then follow the steps written further down.

import processing.pdf.*;
import processing.video.*;

final float coils = 600;
final float radius = 750;

final float thetaMax = coils * 2 * PI;
final float awayStep = radius / thetaMax;
final float chord = 1;
final float rotation = -PI/2;

float away;
float around;
float prev_x;
float prev_y;
float x;
float y;
float theta = chord / awayStep;

boolean movie_playing = false;

// replace "title" with the file name of the video you would like to visualize
String filename = "darktris.mov";

// after you have started the program, wait for it to finish writing the whole movie,
// then press "p" to print the current state of the image (the PDF is saved in the folder "export");

Movie myMovie;

void setup() 
{
  size(600, 600);
  frameRate(960);
  
  beginRecord(PDF, "export/"+filename+".pdf");
  background(123);
  noFill();
  strokeWeight(1.25);
  strokeCap(SQUARE);
  strokeJoin(MITER);
  
  myMovie = new Movie(this, filename);
}

void draw() 
{
  if (frameCount < 3500)
  { 
    float away = awayStep * theta;
    //float around = theta + rotation;
    float around = theta;
    
    prev_x = x;
    prev_y = y;
    x = width/2 + cos ( around ) * away;
    y = height/2 + sin ( around ) * away;
    
    theta += chord / away;
  }
  else
  {
    if (!movie_playing)
    {
      println("play");
      movie_playing = true;
      myMovie.play();
      myMovie.volume(0);
      myMovie.speed(10);
    }
  }
}

// Called every time a new frame is available to read
void movieEvent(Movie m) 
{
  m.read();
  
  float away = awayStep * theta;
  //float around = theta + rotation;
  float around = theta;
  
  prev_x = x;
  prev_y = y;
  x = width/2 + cos ( around ) * away;
  y = height/2 + sin ( around ) * away;

  stroke(getAverageColor(myMovie));
  line(prev_x,prev_y,x,y);
  
  theta += chord / away;
}

color getAverageColor(PImage img) 
{
  img.loadPixels();
  int r = 0, g = 0, b = 0;
  for (int i=0; i<img.pixels.length; i++) {
    color c = img.pixels[i];
    r += c>>16&0xFF;
    g += c>>8&0xFF;
    b += c&0xFF;
  }
  r /= img.pixels.length;
  g /= img.pixels.length;
  b /= img.pixels.length;
  return color(r, g, b);
}

void keyPressed() 
{
  if (key == 'p') 
  {
    endRecord();
  }
}