﻿package  
{
	import flash.display.MovieClip;
	import flash.events.KeyboardEvent;
	import flash.events.Event;
	import flash.utils.Timer;
	
	import com.greensock.TweenLite;
	import com.greensock.easing.*;
	import flash.media.SoundChannel;
	
	public class Main extends MovieClip
	{
		public static const SPLASH_STATE : String = "splash_state";
		public static const START_STATE : String = "start_state";
		public static const LEVEL_STATE : String = "level_state";
		public static const GAME_OVER_STATE : String = "game_over_state";
		
		public static const SPEED : Number = 4;
		public static const LONGEST_KEY_PRESS : Number = 1; // Sekunden
		
		public static const OBSTACLE_MIN_HEIGHT : Number = 10;
		public static const OBSTACLE_MAX_HEIGHT : Number = 100;
		
		public static const MOVE_MAX_HEIGHT : Number = 100;
		public static const MOVE_MAX_DURATION : Number = 2;
		
		public static const JUMP_HEIGHT : Number = 100;
		public static const JUMP_HEIGHT_REQUIRED_FOR_STOMP : Number = 60;
		public static const JUMP_DURATION : Number = 2; // Sekunden
		
		public static const PLAYER1_TITLE : String = "player1";
		public static const PLAYER2_TITLE : String = "player2";
		
		public static const CONTAINER_WIDTH : Number = 960;
		public static const CONTAINER_HEIGHT : Number = 200;
		
		public static const SCREEN_SHAKE_DURATION_IN : Number = 0.2; // Sekunden
		public static const SCREEN_SHAKE_DURATION_OUT : Number = 0.5; // Sekunden
		public static const SCREEN_SHAKE_DISTANCE : Number = 10; // Sekunden
		
		public static const WAVE_MOVE_UP_OFFSET : Number = 10;
		
		public static const FALLING_DURATION : Number = 0.5; // Sekunden
		
		public static const FADE_DURATION : Number = 4;
		
		public static const TUTORIAL_TEXT_DURATION : Number = 3;
		
		private var _currState : String;
		
		private var _currLevel : Level;
		private var _level1 : Level;
		private var _startScreen : StartScreen;
		private var _splashScreen : SplashScreen;
		private var _gameOverScreen : GameOverScreen;
		
		private var _keyDownTimePlayer1 : Date;
		private var _keyDownTimePlayer2 : Date;
		
		private var _keyDownPlayer1 : Boolean;
		private var _keyDownPlayer2 : Boolean;
		
		private var _player1 : Player;
		private var _player2 : Player;
		
		private var wavesMusic : WavesMusic;
		private var musicChannel : SoundChannel;
		
		public function Main() 
		{
			_splashScreen = new SplashScreen();
			_startScreen = new StartScreen();
			_gameOverScreen = new GameOverScreen();
			_splashScreen.alpha = 0;
			_startScreen.alpha = 0;
			_gameOverScreen.alpha = 0;
			
			this.addChild(_splashScreen);
			this.addChild(_startScreen);
			this.addChild(_gameOverScreen);
			
			_level1 = new Level1();
			_level1.init(this);
			_currLevel = _level1;
			_currLevel.x = CONTAINER_WIDTH;
				
			_player1 = _currLevel.player1_container_mc.player_mc;
			_player2 = _currLevel.player2_container_mc.player_mc;
				
			this.addChild(_currLevel);
			
			_keyDownPlayer1 = false;
			_keyDownPlayer2 = false;
			
			this.stage.addEventListener(KeyboardEvent.KEY_DOWN, handleKeyDown);
			this.stage.addEventListener(KeyboardEvent.KEY_UP, handleKeyUp);
			
			enterState(SPLASH_STATE);
			
			wavesMusic = new WavesMusic();
			musicChannel = wavesMusic.play(0,100);
		}
		
		public function enterState (s : String) : void
		{
			_currState = s;
			
			if (s == SPLASH_STATE)
			{
				TweenLite.to(_splashScreen,FADE_DURATION,{alpha: 1, ease: Sine.easeOut});
				TweenLite.to(_splashScreen,FADE_DURATION,{alpha: 0, ease: Sine.easeIn, delay: FADE_DURATION, onComplete: handleSplashComplete});
			}
			else if (s == START_STATE)
			{
				_currLevel.reset();
				
				_startScreen.alpha = 0;
				_startScreen.x = 0;
				_startScreen.visible = true;
				
				if (_gameOverScreen.alpha > 0.9)
				{
					TweenLite.to(_gameOverScreen,FADE_DURATION/2,{alpha: 0, ease: Sine.easeIn});
					TweenLite.to(_startScreen,FADE_DURATION/2,{alpha: 1, ease: Sine.easeOut, delay: FADE_DURATION/2});
				}
				else
				{
					TweenLite.to(_startScreen,FADE_DURATION,{alpha: 1, ease: Sine.easeOut});
				}
				
			}
			if (s == LEVEL_STATE)
			{
				_currLevel.alpha = 1;
				_currLevel.x = CONTAINER_WIDTH;
				
				TweenLite.to(_startScreen,FADE_DURATION,{x: -CONTAINER_WIDTH, ease: Sine.easeIn});
				TweenLite.to(_currLevel,FADE_DURATION,{x: 0, ease: Sine.easeIn, onComplete: handleLevelComplete});
				_currLevel.running = true;
			}
			else if (s == GAME_OVER_STATE)
			{
				// switch Game Over Screen to appropriate ending
				_gameOverScreen.gotoAndStop(_currLevel.gameOverStatus);
				TweenLite.to(_currLevel,FADE_DURATION,{alpha: 0, ease: Sine.easeIn});
				TweenLite.to(_gameOverScreen,FADE_DURATION,{alpha: 1, ease: Sine.easeOut, delay: FADE_DURATION*2, onComplete: handleGameOverComplete});
			}
		}
		
		private function handleSplashComplete () : void
		{
			_splashScreen.visible = false;
			enterState(START_STATE);
		}
		
		private function handleLevelComplete () : void
		{
			_startScreen.visible = false;
		}
		
		private function handleGameOverComplete () : void
		{
			//_currLevel.reset();
			
			//enterState(START_STATE);
		}
		
		private function handleKeyDown (e : KeyboardEvent) : void
		{
			/*if (e.keyCode == 65) // a
			{
				if (!_keyDownPlayer1)
				{
					_keyDownPlayer1 = true;
					_keyDownTimePlayer1 = new Date();
				}
			}
			else if (e.keyCode == 76) // l
			{
				if (!_keyDownPlayer2)
				{
					_keyDownPlayer2 = true;
					_keyDownTimePlayer2 = new Date();
				}
			}*/
		}
		
		private function handleKeyUp (e : KeyboardEvent) : void
		{
			var keyPressedTime = new Date();
			
			if (_currState == START_STATE  && _startScreen.alpha > 0.9)
			{
				enterState(LEVEL_STATE);
			}
			
			else if (_currState == GAME_OVER_STATE && _gameOverScreen.alpha > 0.9)
			{
				enterState(START_STATE);
			}
			
			else if (_currState == LEVEL_STATE && _currLevel.x < 10)
			{
				if (e.keyCode == 87) // w
				{
					/*if (_keyDownPlayer1)
					{
						_keyDownPlayer1 = false;
						keyPressedTime -= _keyDownTimePlayer1.time;*/
						_currLevel.handleKeyUp(_player1);
					/*}*/
				}
				else if (e.keyCode == 77) // m
				{
					/*if (_keyDownPlayer2)
					{
						_keyDownPlayer2 = false;
						keyPressedTime -= _keyDownTimePlayer2.time;*/
						_currLevel.handleKeyUp(_player2);
					/*}*/
				}
			}
		}
		
		public function get currState () : String
		{
			return _currState;
		}
	}
}
